const inherit = require('inherit');
const AbstractPage = require('../../AbstractPage');
const InfoView = require('./InfoView');
const InfoLayout = require('./InfoLayout');
const MessageView = require('../../../blocks/message/MessageView');

module.exports = inherit(AbstractPage, {
    name: 'client.info',

    _clientRe: /[0-9a-f]{32}/,
    open: function () {
        if (this._controller.isIntranet() && !this._controller.getAuth().isLoggedIn()) {
            this._logger.info('User not logged in, redirecting to auth');
            this._controller.getAuth().authorize({noreturn: 1});
            return require('when').reject();
        }

        const pathname = this._controller.getUrl().pathname;
        const clientId = pathname.match(this._clientRe)[0];
        this._logger.info('opened for clientId %s', clientId);

        const layout = new InfoLayout(this._controller);

        if (pathname.indexOf('/undosecret') > -1) {
            this._messageView = new MessageView('app.passwordReset');
        }
        if (pathname.indexOf('/secretundone') > -1) {
            this._messageView = new MessageView('app.passwordReset.undone');
        }

        if (this._messageView) {
            layout.append(this._messageView);
        }

        this._logger.debug('Rendering');
        return layout
            .append(new InfoView(this._api, clientId))
            .render(this._controller.getLang())
            .then((rendered) => {
                this._logger.verbose('Sending', rendered);
                return this._controller.sendPage(rendered);
            })
            .then(() => this._logger.info('Page sent'))
            .catch(this._clientNotFoundHandler.bind(this));
    }
});
