const inherit = require('inherit');
const putils = require('putils');
const AbstractPage = require('../../AbstractPage');
const ClientView = require('./ClientView');
const ClientLayout = require('./ClientLayout');
const HTTPException = require('../../../lib/exceptions/http/HTTPException');
const ErrorPage = require('../../error/ErrorPage');

const HAS_PLUS_ATTRIBUTE = 1015;

module.exports = inherit(AbstractPage, {
    name: 'client.new',

    open: async function (req, bbServiceTicket) {
        const {params: {clientId = null} = {}} = req;
        const [csrf, uatraits, userInfo, sessionId, client, clientList] = await Promise.all([
            this._controller.getCsrfToken(),
            this._controller.getUatraits(),
            this._api.userInfoV2({noSlugs: true}),
            this._controller
                .getAuth()
                .sessionID({attributes: [HAS_PLUS_ATTRIBUTE].join(',')}, {'X-Ya-Service-Ticket': bbServiceTicket}),
            clientId ? this._api.clientInfoVer3New(clientId, true) : Promise.resolve({client: {}}),
            ['/'].includes(req.originalUrl) ? this._api.listCreatedClientsVer2New() : Promise.resolve([])
        ]);

        const lang = this._controller.getLang();

        if (clientId && !client.viewed_by_owner && req.originalUrl.startsWith('/client/edit')) {
            return new ErrorPage(this._controller, this._api)
                .setError(new HTTPException(403, putils.i18n(lang, 'common.errors.access_denied')))
                .open();
        }

        this._logger.debug('Rendering');

        return new ClientLayout(this._controller)
            .append(new ClientView(this._controller, csrf, uatraits, userInfo, sessionId, client, clientList))
            .render(lang)
            .then((rendered) => {
                this._logger.verbose('Sending', rendered);
                return this._controller.sendPage(rendered);
            })
            .then(() => this._logger.info('Page sent'));
    }
});
