const mapPlatforms = (platforms, result = {}) => {
    if (platforms) {
        if (platforms.web) {
            result.webCallbackUrls = platforms.web.redirect_uris;
        }
        if (platforms.ios) {
            result.iosAppIds = platforms.ios.app_ids;
            result.iosAppstoreUrl = platforms.ios.appstore_url;
            result.iosDomains = platforms.ios.universal_link_domains;
        }
        if (platforms.android) {
            result.androidPackageNames = platforms.android.package_names;
            result.androidAppstoreUrl = platforms.android.appstore_url;
            result.androidFingerprints = platforms.android.cert_fingerprints;
            result.androidSchemes = platforms.android.custom_urlschemes;
        }
        if (platforms.turboapp) {
            result.turboappUrl = platforms.turboapp.base_url;
        }

        result.platforms = Object.keys(platforms).reduce((acc, key) => {
            acc[key] = true;

            return acc;
        }, {});
    }
};

const mapScopes = (scopes, result = {}) => {
    if (scopes) {
        result.scopes = Object.entries(scopes).reduce((acc, [section, _scopes]) => {
            acc[section] = {};
            Object.keys(_scopes).forEach(
                (key) =>
                    (acc[section][key] = {
                        title: _scopes[key].title,
                        requiresApproval: _scopes[key].requires_approval,
                        ttl: _scopes[key].ttl,
                        isTtlRefreshable: _scopes[key].is_ttl_refreshable
                    })
            );

            return acc;
        }, {});
    }
};

const mapClient = (client) => {
    const newClient = {
        clientId: client.id,
        title: client.title,
        icon: client.icon,
        iconId: client.icon_id,
        iconUrl: client.icon_url,
        homepage: client.homepage,
        callback: client.callback,
        description: client.description,
        createTime: client.create_time,
        isYandex: client.is_yandex,
        isDeleted: client.is_deleted,
        secret: client.secret,
        approveStatus: client.approval_status,
        isBlocked: client.blocked,
        ttl: client.token_ttl
    };

    mapPlatforms(client.platforms, newClient);
    mapScopes(client.scopes, newClient);

    return newClient;
};

module.exports = {
    mapClient,
    mapClientsList: (clientsList) =>
        clientsList.reduce(
            (acc, client) => {
                acc.idList.push(client.id);
                acc.clientsMap[client.id] = mapClient(client);

                return acc;
            },
            {idList: [], clientsMap: {}}
        )
};
