const inherit = require('inherit');
const assert = require('assert');
const PView = require('pview');
const HTTPException = require('../../lib/exceptions/http/HTTPException');

module.exports = inherit(PView, {
    name: 'error',

    /**
     * @param {Error}   error
     * @param {boolean} planned
     * @constructor
     */
    __constructor: function (error, planned) {
        assert(error instanceof Error, 'Error should be an instance of Error');
        assert(typeof planned === 'boolean', 'Planned status is a boolean');

        this.__base.apply(this, arguments);
        this._error = error;
        this._planned = planned;
    },

    _compile: function () {
        const error = {
            http: false,
            name: this._error.name,
            stack: this._error.stack,
            message: this._error.message,
            isPlanned: this._planned
        };

        if (this._error instanceof HTTPException) {
            Object.assign(error, {
                http: true,
                code: this._error.code
            });
        }

        this._logger.verbose('Compiled: %j', error);
        return {error};
    }
});
