const inherit = require('inherit');
const i18n = require('putils').i18n;
const MyClientsView = require('./MyClientsView');
const IndexLayout = require('./IndexLayout');
const ErrorPage = require('../error/ErrorPage');
const AbstractPage = require('../AbstractPage');
const HTTPException = require('../../lib/exceptions/http/HTTPException');

module.exports = inherit(AbstractPage, {
    name: 'index',

    open: function () {
        this._logger.info('opened');

        const layout = new IndexLayout(this._controller);

        if (this._controller.getAuth().isLoggedIn()) {
            this._logger.info('User logged in, appending clientList');
            layout.append(new MyClientsView(this._api, this._controller));
        }

        if (this._messageView) {
            layout.append(this._messageView);
        }

        this._logger.debug('Rendering');
        return layout
            .render(this._controller.getLang())
            .then((rendered) => {
                this._logger.verbose('Sending', rendered);
                return this._controller.sendPage(rendered);
            })
            .then(() => this._logger.info('Page sent'))
            .catch(() =>
                new ErrorPage(this._controller, this._controller._request.oauthApi)
                    .setError(new HTTPException(500, i18n(this._controller.getLang(), 'authorize.errors.internal')))
                    .open()
            );
    }
});
