const inherit = require('inherit');
const assert = require('assert');
const PView = require('pview');
const OauthApi = require('papi/OAuth');
const ClientListView = require('../../blocks/clientList/ClientListView');

module.exports = inherit(PView, {
    name: 'client.myClients',

    __constructor: function (api) {
        assert(api instanceof OauthApi, 'Api instance expected');
        this._api = api;
        this.__base.apply(this, arguments);
    },

    _compile: function () {
        return this._api
            .listCreatedClientsVer2()
            .then((createdClients) => new ClientListView(createdClients).compile());
    }
});
