const inherit = require('inherit');
const assert = require('assert');
const PView = require('pview');
const OauthApi = require('papi/OAuth');

const Layout = require('./VerificationCodeLayout');
const AbstractPage = require('../AbstractPage');

const CodeView = inherit(PView, {
    name: 'verification_code',
    __constructor: function (code) {
        assert(code && typeof code === 'string', 'Code should be a string');
        this.__base.apply(this, arguments);
        this._code = code;
    },

    _compile: function () {
        return {verification_code: this._code};
    }
});

module.exports = inherit(AbstractPage, {
    name: 'verificationCode',

    _codeRe: /^\d+$/,
    open: function () {
        this._logger.info('opened');

        const layout = new Layout(this._controller);

        const code = this._controller.getRequestParam('code');
        if (this._codeRe.test(code)) {
            layout.append(new CodeView(code));
        }

        this._logger.debug('Rendering');
        return layout
            .render()
            .then((rendered) => {
                this._logger.verbose('Sending', rendered);
                return this._controller.sendPage(rendered);
            })
            .then(() => this._logger.info('Page sent'));
    }
});
