/* borschik:include:{{RELATIVEROOT}}/loc/dynamic/tanker.dynamic.{{LANG}}.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */

var parseUrl = function() {
    var a = document.createElement('a');
    a.href = document.location.href;
    return a;
};

var params2hash = function(params) {
    var hash = {};
    params.split('&').forEach(function(pair) {
        var split = pair.split('=', 2);
        hash[split[0]] = split[1];
    });
    return hash;
};

var getFragment = function() {
    return params2hash(parseUrl().hash.replace(/^#/, ''));
};

var getQuery = function() {
    return params2hash(parseUrl().search.replace(/^\?/, ''));
};

passport.block('verification-token', {
    init: function() {
        var token = getFragment().access_token;
        if (!getQuery().code && token) {
            this.$('.js-verification-code-flow-token-output').text(token);

            this.$('.js-verification-code-flow')
                .removeClass('verification-code-flow_hidden');
        }
    }
});

passport.block('verification-error', {
    init: function() {
        var error = getQuery().error || getFragment().error;
        if (!getQuery().code && !getFragment().access_token && error) {
            this.$('.js-verification-code-flow-error-code').text(error);

            var description = getQuery().error_description || getFragment().error_description;
            this.$('.js-verification-code-flow-error-description')
                .text(decodeURIComponent(description));

            this.$('.js-verification-code-flow')
                .removeClass('verification-code-flow_hidden');
        }
    }
});

$(function() {
    passport.init();
});
