module.exports = {
    root: true,
    env: {
        es6: true
    },
    parser: 'babel-eslint',
    extends: [
        'eslint:recommended',
        'plugin:react/recommended',
        'prettier',
        'prettier/react',
        'plugin:compat/recommended'
    ],
    plugins: ['react', 'react-hooks'],
    parserOptions: {
        ecmaVersion: 6,
        sourceType: 'module',
        ecmaFeatures: {
            modules: true
        }
    },
    globals: {
        $: false,
        i18n: false,
        process: false
    },
    rules: {
        'consistent-this': ['error', 'self'],
        camelcase: 'warn',
        'template-curly-spacing': 'error',
        'object-curly-spacing': 'error',
        'react/prop-types': 'off',
        'max-len': [
            'error',
            {
                code: 120
            }
        ],
        'no-console': [
            'error',
            {
                allow: ['warn', 'error']
            }
        ],
        'react-hooks/rules-of-hooks': 'error',
        'react-hooks/exhaustive-deps': 'warn',
        curly: 'error',
        'newline-after-var': [2, 'always'],
        'react/display-name': 'off',
        'react/no-string-refs': 'warn',
        'react/no-deprecated': 'error',
        'react/no-did-mount-set-state': 'error',
        'react/no-did-update-set-state': 'error',
        'react/no-direct-mutation-state': 'error',
        'react/no-is-mounted': 'error',
        'react/no-set-state': 'off',
        'react/no-unknown-property': 'error',
        'react/prefer-es6-class': 'warn',
        'react/self-closing-comp': 'error',
        'react/jsx-wrap-multilines': 'error',
        'react/jsx-curly-spacing': ['error', 'never'],
        'react/jsx-equals-spacing': 'error',
        'react/jsx-indent-props': 'error',
        'react/jsx-no-bind': [
            'error',
            {
                allowArrowFunctions: true
            }
        ],
        'no-warning-comments': ['error', {terms: ['FIXME'], location: 'anywhere'}],
        'react/jsx-no-duplicate-props': 'error',
        'react/jsx-no-undef': 'error',
        'react/jsx-pascal-case': 'error',
        'react/jsx-uses-react': 'error',
        'react/jsx-uses-vars': 'error',
        'react/jsx-boolean-value': [2, 'always'],
        'jsx-quotes': ['error', 'prefer-single'],
        'compat/compat': 'off'
    }
};
