import React from 'react';
import {cn} from '@bem-react/classname';
import passport from '@plibs/pclientjs/js/passport';
import {Greed} from '@plibs/greed';
import {AuthorizeAccountLink} from './components/AuthorizeAccountLink';
import {AuthorizeScopes} from './components/AuthorizeScopes';
import {AuthorizeAllowButton} from './components/AuthorizeAllowButton';
import {AuthorizeClient} from './components/AuthorizeClient';
import {AuthorizeAvatars} from './components/AuthorizeAvatars';
import {AuthorizeBackground} from './components/AuthorizeBackground';
import {metric} from './metric';
import './App.styl';

const b = cn('Authorize');

const AUTH_PAGE_OPEN = 'AUTH_PAGE_OPEN';

export class App extends React.Component {
    componentDidMount() {
        metric.count(AUTH_PAGE_OPEN);
        this.sendFingerprint();
    }
    async sendFingerprint() {
        try {
            if (Greed && Greed.get) {
                const greedResult = await Greed.safeGet();
                const {common: {yandexuid, csrf} = {}, authorize: {uid} = {}} = this.props;

                // Трека в этом месте нет, но он используется для шифрования в passport.api.log
                passport.api.setTrackId(csrf);
                passport.api.setCsrfToken(csrf);
                passport.api.log(
                    {action: 'oauth fingerprint', greedResult: JSON.stringify(greedResult), yandexuid, uid},
                    {encrypt: true, logUrl: '/authorize/logger'}
                );
            }
        } catch (error) {
            // DO NOTHING
        }
    }
    render() {
        return (
            <div className={b()}>
                <div className={b('wrap')}>
                    <AuthorizeBackground />
                    <div className={b('card')}>
                        <div className={b('avatars')}>
                            <AuthorizeAvatars />
                        </div>
                        <div className={b('title')}>{i18n('Authorize.title')}</div>
                        <div className={b('account')}>
                            <AuthorizeAccountLink />
                        </div>
                        <form className={b('form')} action='/authorize/allow' method='post'>
                            <div className={b('button')}>
                                <AuthorizeAllowButton />
                            </div>
                            <div className={b('client')}>
                                <AuthorizeClient />
                            </div>
                            <div className={b('scopes')}>
                                <AuthorizeScopes />
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        );
    }
}
