import React from 'react';
import ReactDOM from 'react-dom';
import {Provider} from 'react-redux';
import configureStore from './configureStore';
import {App} from './App.jsx';
import metrics from '../metrics';

document.addEventListener('DOMContentLoaded', () => {
    const root = document.getElementById('root');
    const initialState = JSON.parse(root.getAttribute('data-redux-state'));
    const store = configureStore(initialState);
    const {metrics: {header = '', experiments = ''} = {}, common = {}, authorize = {}} = initialState;

    root.removeAttribute('data-redux-state');
    metrics.init(header, experiments);

    ReactDOM.render(
        <Provider store={store}>
            <App common={common} authorize={authorize} />
        </Provider>,
        root
    );
});
