import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {metric} from '../../metric';

import './AuthorizeAccountLink.styl';

const b = cn('AuthorizeAccountLink');

const AUTH_PAGE_CHANGE_ACCOUNT = 'AUTH_PAGE_CHANGE_ACCOUNT';

const onClick = () => metric.count(AUTH_PAGE_CHANGE_ACCOUNT);

export const AuthorizeAccountLink = ({changeAccountLink}) => (
    <a href={changeAccountLink} className={b()} onClick={onClick}>
        {i18n('Authorize.account.link')}
    </a>
);

AuthorizeAccountLink.propTypes = {
    changeAccountLink: PropTypes.string
};
