import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {metric} from '../../metric';

const AUTH_PAGE_ALLOW = 'AUTH_PAGE_ALLOW';

const onClick = () => metric.count(AUTH_PAGE_ALLOW);

export const AuthorizeAllowButton = ({name, isDisabled}) => (
    <Button view='oauth-authorize' size='l' width='max' type="submit" disabled={isDisabled} onClick={onClick}>
        {i18n('Authorize.button.allow').replace('%name', name)}
    </Button>
);

AuthorizeAllowButton.propTypes = {
    name: PropTypes.string,
    isDisabled: PropTypes.bool
};
