import React from 'react';
import PropTypes from 'prop-types';
import {AuthorizeScopesInputs} from '../AuthorizeScopesInputs';

export class AuthorizeScopes extends React.Component {
    onCheckboxesStateChange = (isSomeCheckboxChecked) => {
        const {setAllowButtonDisableState} = this.props;

        setAllowButtonDisableState(!isSomeCheckboxChecked);
    };

    render() {
        const {scopes = [], form = []} = this.props;

        return (
            <div>
                {form.map(({field, value}) => value && <input type='hidden' key={field} name={field} value={value} />)}
                <AuthorizeScopesInputs scopes={scopes} onCheckboxesStateChange={this.onCheckboxesStateChange} />
            </div>
        );
    }
}

AuthorizeScopes.propTypes = {
    scopes: PropTypes.array,
    form: PropTypes.arrayOf(
        PropTypes.shape({
            field: PropTypes.string,
            value: PropTypes.string
        })
    ),
    setAllowButtonDisableState: PropTypes.func.isRequired
};
