import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './AuthorizeScopesInputs.styl';

const b = cn('AuthorizeScopesInputs');

export class AuthorizeScopesInputs extends React.Component {
    isSomeCheckboxChecked = true;
    checkboxes = [];
    checkboxRef = (permission) => this.checkboxes.push(permission);

    onCheckboxChange = () => {
        const {onCheckboxesStateChange} = this.props;

        const isSomeCheckboxChecked = this.checkboxes.some((permission) => permission.checked);

        if (this.isSomeCheckboxChecked !== isSomeCheckboxChecked) {
            this.isSomeCheckboxChecked = isSomeCheckboxChecked;
            onCheckboxesStateChange(isSomeCheckboxChecked);
        }
    };

    render() {
        const {scopes = []} = this.props;

        const isSomeScopeOptionalOrGranted = scopes.some((scope) => scope.optional || scope.alreadyGranted);

        return (
            <div className={b({point: !isSomeScopeOptionalOrGranted})}>
                {scopes.map((scope) => (
                    <div className={b('item')} key={scope.id}>
                        <input
                            id={scope.id}
                            type='checkbox'
                            className={b('checkbox')}
                            name='granted_scopes'
                            value={scope.id}
                            defaultChecked={true}
                            onChange={this.onCheckboxChange}
                            ref={this.checkboxRef}
                        />
                        <label
                            className={b('label', {checkbox: !scope.alreadyGranted && scope.optional})}
                            htmlFor={!scope.alreadyGranted && scope.optional ? scope.id : undefined}
                        >
                            <div className={b('iconWrap')}>
                                {isSomeScopeOptionalOrGranted ? (
                                    !scope.alreadyGranted && scope.optional ? (
                                        <div className={b('icon', {checkbox: true})}>
                                            <svg
                                                className={b('svg')}
                                                width='11'
                                                height='10'
                                                viewBox='0 0 11 10'
                                                fill='none'
                                                xmlns='http://www.w3.org/2000/svg'
                                            >
                                                <path
                                                    fillRule='evenodd'
                                                    clipRule='evenodd'
                                                    d='M10.1306 0.723918C10.5592 1.07218 10.6244 1.70199 10.2761 2.13062L4.77611 9.13062C4.59758 9.35036 4.33427 9.48412 4.05152 9.4987C3.76877 9.51329 3.49309 9.40734 3.29289 9.20714L0.292893 6.20714C-0.0976311 5.81661 -0.0976311 5.18345 0.292893 4.79293C0.683417 4.4024 1.31658 4.4024 1.70711 4.79293L3.92308 7.0089L8.72389 0.869439C9.07215 0.440804 9.70196 0.375651 10.1306 0.723918Z'
                                                    fill='#222426'
                                                />
                                            </svg>
                                        </div>
                                    ) : (
                                        <div className={b('icon')}>
                                            <svg
                                                className={b('svg')}
                                                width='12'
                                                height='15'
                                                viewBox='0 0 12 15'
                                                fill='none'
                                                xmlns='http://www.w3.org/2000/svg'
                                            >
                                                <path
                                                    fillRule='evenodd'
                                                    clipRule='evenodd'
                                                    d='M0 7.5C0 6.67157 0.671573 6 1.5 6H2V4C2 1.79086 3.79086 0 6 0C8.20914 0 10 1.79086 10 4V6H10.5C11.3284 6 12 6.67157 12 7.5V13.5C12 14.3284 11.3284 15 10.5 15H1.5C0.671573 15 0 14.3284 0 13.5V7.5ZM6 2C4.89543 2 4 2.89543 4 4V5.99726H8V4C8 2.89543 7.10457 2 6 2ZM10 13V8H2V13H10Z'
                                                    fill='#939CB0'
                                                    fillOpacity='0.8'
                                                />
                                            </svg>
                                        </div>
                                    )
                                ) : (
                                    <div className={b('icon', {point: true})} />
                                )}
                            </div>
                            <span>{scope.title}</span>
                        </label>
                    </div>
                ))}
            </div>
        );
    }
}

AuthorizeScopesInputs.propTypes = {
    scopes: PropTypes.array,
    onCheckboxesStateChange: PropTypes.func.isRequired
};
