import metrics from '../../metrics';

const METRIC_CREATE_APP_SUCCESS = 'METRIC_CREATE_APP_SUCCESS';
const METRIC_CREATE_APP_ERROR = 'METRIC_CREATE_APP_ERROR';

export default {
    _createRequest: function(url, body, method) {
        return new Request(url, {
            body,
            method,
            mode: 'same-origin',
            credentials: 'same-origin',
            redirect: 'follow'
        });
    },

    _validateResponse: function(res) {
        let errors;

        if (res.ok) {
            const contentType = res.headers.get('content-type') || '';

            if (contentType.includes('application/json')) {
                return res.json().then((json) => {
                    if (json.status === 'error') {
                        return Promise.reject(json);
                    }

                    return Promise.resolve(json);
                });
            }
        }

        if (res.status === 500 || res.status === 404) {
            errors = ['form.internal'];
        }

        return Promise.reject({
            status: 'error',
            errors
        });
    },

    saveApplication: function(clientId, formData) {
        const url = clientId ? `/client/edit/${clientId}` : '/client/new';
        const request = fetch(this._createRequest(url, formData, 'POST')).then(this._validateResponse);

        if (clientId) {
            return request;
        }

        return request.then(
            (result) => {
                metrics.send(METRIC_CREATE_APP_SUCCESS);
                return result;
            },
            (error) => {
                metrics.send(METRIC_CREATE_APP_ERROR);
                throw error;
            }
        );
    },

    validateApplicationChanges: function(clientId = '', formData) {
        const url = `/client/validate/${clientId}`;

        return fetch(this._createRequest(url, formData, 'POST')).then(this._validateResponse);
    }
};
