import React from 'react';
import ReactDOM from 'react-dom';
import {Provider} from 'react-redux';
import configureStore from './configureStore';
import EditPage from './components/Edit.jsx';
import {appInitialized} from './actions/app';
import metrics from '../../metrics';

$(() => {
    const root = document.getElementById('root');
    const initialState = JSON.parse(root.getAttribute('data-redux-state'));
    const store = configureStore(initialState);
    const hostParts = location.host.split('.');
    const tld = hostParts[hostParts.length - 1];
    const lang = document.documentElement.getAttribute('lang');
    const {metrics: {header = '', experiments = ''} = {}} = initialState;
    
    root.removeAttribute('data-redux-state');

    metrics.init(header, experiments);
    store.dispatch(appInitialized());

    ReactDOM.render(
        <Provider store={store}>
            <EditPage tld={tld} lang={lang} />
        </Provider>,
        root
    );
});
