import React from 'react';
import {Provider} from 'react-redux';
import configureStore from './configureStore';
import {renderToString} from 'react-dom/server';
import EditPage from './components/Edit.jsx';
import {appInitialized} from './actions/app';

export default function (state, tld, lang) {
    const store = configureStore(state);

    store.dispatch(appInitialized());

    return renderToString(
        <Provider store={store}>
            <EditPage tld={tld} lang={lang} />
        </Provider>
    );
}
