import React from 'react';
import {Route, Switch, Redirect, withRouter} from 'react-router-dom';
import {ClientPageTemplate} from './components/common/ClientPageTemplate';
import {ClientEditPage} from './components/pages/Edit';
import {ClientCreatePage} from './components/pages/Create';
import {ClientInfoPage} from './components/pages/Info';
import {ClientListPage} from './components/pages/List';
import {ROUTES} from './const';

const ClientApp = ({location}) => (
    <ClientPageTemplate>
        <Switch location={location}>
            <Route path={ROUTES.FORM_CREATE_WITH_TAG} render={() => <ClientCreatePage />} />
            <Route path={ROUTES.FORM_CREATE} render={() => <ClientCreatePage />} />
            <Route path={ROUTES.FORM_EDIT} render={() => <ClientEditPage />} />
            <Route path={ROUTES.INFO} render={() => <ClientInfoPage />} />
            <Route path={ROUTES.LIST} render={() => <ClientListPage />} />
            <Redirect to={ROUTES.LIST} exact={true} push={true} />
        </Switch>
    </ClientPageTemplate>
);

export const App = withRouter(ClientApp);
