import React from 'react';
import ReactDOM from 'react-dom';
import {Provider} from 'react-redux';
import {ConnectedRouter} from 'connected-react-router';
import createBrowserHistory from 'history/createBrowserHistory';
import metrics from '../../metrics';
import configureStore from './configureStore';
import {App} from './app';

document.addEventListener('DOMContentLoaded', () => {
    const root = document.getElementById('root');
    const initialState = JSON.parse(root.getAttribute('data-redux-state'));
    const history = createBrowserHistory();
    const store = configureStore(initialState, history);
    const {metrics: {header = '', experiments = ''} = {}} = initialState;

    root.removeAttribute('data-redux-state');

    metrics.init(header, experiments);

    ReactDOM.render(
        <Provider store={store}>
            <ConnectedRouter history={history}>
                <App />
            </ConnectedRouter>
        </Provider>,
        root
    );
});
