import React from 'react';
import {Popup} from 'pcomponents/Popup';
import {Drawer} from 'pcomponents/Drawer';
import {cn} from '@bem-react/classname';
import {ClientIcon} from '../ClientIcon';

import './ClientBurger.styl';

const b = cn('ClientBurger');

export class ClientBurger extends React.Component {
    ref = React.createRef(null);
    state = {isOpened: false};
    toggleOpenState = () => this.setState({isOpened: !this.state.isOpened});
    render() {
        const {children, isTouch, isMobile} = this.props;
        const {isOpened} = this.state;
        const showDrawer = isMobile || isTouch;

        return (
            <>
                <div className={b()} ref={this.ref} onClick={this.toggleOpenState}>
                    <ClientIcon type='burger' />
                </div>

                {showDrawer ? (
                    <Drawer visible={isOpened} view='default' onClose={this.toggleOpenState}>
                        {children}
                    </Drawer>
                ) : (
                    <Popup
                        directions={['bottom-right', 'bottom-center', 'bottom-left']}
                        target='anchor'
                        mainOffset={8}
                        anchor={this.ref}
                        visible={isOpened}
                        onClose={this.toggleOpenState}
                        zIndex={500}
                    >
                        {children}
                    </Popup>
                )}
            </>
        );
    }
}
