import React from 'react';
import {cn} from '@bem-react/classname';
import './ClientField.styl';

const b = cn('ClientField');

export const ClientField = ({title, description, isRequired, isSecondary, isDescriptionAsError, children, hint}) => (
    <div className={b({isSecondary})}>
        {hint && <div className='error-anchor' />}
        {title && (
            <h5 className={b('title')}>
                {title}
                {isRequired && <>&nbsp;*</>}
            </h5>
        )}
        {hint && <div className={b('error')}>{hint}</div>}
        <div className={b('field')}>{children}</div>
        {description && <div className={b('description', {error: isDescriptionAsError})}>{description}</div>}
    </div>
);
