import {connect} from 'react-redux';
import {FORM_ERRORS} from '../../../const';
import {ClientField as Component} from './ClientField';

const mapStateToProps = ({edit: {showErrors = false, validateErrors = {}} = {}} = {}, {errorField = ''} = {}) => {
    const formErrors = FORM_ERRORS[errorField];
    const validateError = validateErrors[errorField];

    return {hint: showErrors && validateError && formErrors ? formErrors[validateError] : ''};
};

export const ClientField = connect(mapStateToProps)(Component);
