import React from 'react';
import {Link} from 'pcomponents/Link';
import {cn} from '@bem-react/classname';
import {metric} from '../../../metric';
import './ClientFooter.styl';

const b = cn('ClientFooter');

const sendFeedbackMetric = () => metric.goal('lk_footer_feedback_click');
const sendSupportMetric = () => metric.goal('lk_footer_offerta_click');

export const ClientFooter = ({year, tld}) => (
    <div className={b()}>
        <Link
            className={b('item')}
            theme='normal'
            target='_blank'
            href={`https://forms.yandex.${tld}/surveys/1792/`}
            onClick={sendFeedbackMetric}
        >
            {i18n('ClientCommon.footer.feedback')}
        </Link>
        <Link
            className={b('item')}
            theme='normal'
            target='_blank'
            href={`https://yandex.${tld}/support/`}
            onClick={sendSupportMetric}
        >
            {i18n('ClientCommon.footer.support')}
        </Link>
        <div className={b('item')}>{i18n('ClientCommon.footer.copyright').replace('%year', year)}</div>
    </div>
);
