import React from 'react';
import {cn} from '@bem-react/classname';
import './ClientFormBlock.styl';

const b = cn('ClientFormBlock');

export const ClientFormBlock = ({title, subtitle, isFullWidth, children}) => (
    <div className={b({isFullWidth})}>
        {title && <h3 className={b('title')}>{title}</h3>}
        {subtitle && <h4 className={b('subtitle')}>{subtitle}</h4>}
        {children && <div className={b('content')}>{children}</div>}
    </div>
);
