import {connect} from 'react-redux';
import {withRouter} from 'react-router-dom';
import {User} from 'pcomponents/User';

const mapStateToProps = (
    {
        uatraits: {isTouch, isMobile} = {},
        settings: {tld, host, lang, isTesting} = {},
        userInfo: {hasPlus = false, avatarId, ci} = {}
    } = {},
    {location: {pathname = ''} = {}}
) => ({
    avatarId,
    isTesting,
    lang,
    hasPlus,
    tld,
    retpath: `https://${host}${pathname}`,
    ci,
    logoutOrigin: 'oauth_client_head_logout',
    project: 'oauth',
    isMobile: isMobile || isTouch,
    isNewUserLegoComponent: true
});

export const ClientHeadUser = withRouter(connect(mapStateToProps)(User));
