/* eslint-disable max-len */
import React from 'react';
import {cn} from '@bem-react/classname';
import './ClientIcon.styl';

const b = cn('ClientIcon');

const ICONS = {
    attach: (
        <svg width='24' height='24' viewBox='0 0 24 24' fill='none' xmlns='http://www.w3.org/2000/svg' className={b()}>
            <path
                d='M16.6169 14.4957C17.0075 14.1051 17.6406 14.1051 18.0311 14.4957C18.4217 14.8862 18.4217 15.5194 18.0311 15.9099L14.8492 19.0919C12.1155 21.8255 7.68334 21.8255 4.94967 19.0919C2.216 16.3582 2.216 11.926 4.94967 9.19237L10.6065 3.53551C12.5591 1.58289 15.725 1.58289 17.6776 3.53551C19.6302 5.48813 19.6302 8.65396 17.6776 10.6066L12.0207 16.2634C10.8492 17.435 8.94967 17.435 7.77809 16.2634C6.60652 15.0919 6.60652 13.1924 7.77809 12.0208L12.3743 7.4246C12.7648 7.03407 13.398 7.03407 13.7885 7.4246C14.179 7.81512 14.179 8.44829 13.7885 8.83881L9.19231 13.435C8.80178 13.8255 8.80178 14.4587 9.19231 14.8492C9.58283 15.2397 10.216 15.2397 10.6065 14.8492L16.2634 9.19237C17.4349 8.02079 17.4349 6.1213 16.2634 4.94972C15.0918 3.77815 13.1923 3.77815 12.0207 4.94972L6.36388 10.6066C4.41126 12.5592 4.41126 15.725 6.36388 17.6776C8.3165 19.6303 11.4823 19.6303 13.4349 17.6776L16.6169 14.4957Z'
                fill='#262633'
            />
        </svg>
    ),
    trash: (
        <svg width='24' height='24' viewBox='0 0 24 24' fill='none' xmlns='http://www.w3.org/2000/svg' className={b()}>
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M12.6631 1.5H11.3369C10.2683 1.5 9.84723 1.58935 9.41558 1.77018C8.98393 1.95101 8.62364 2.22332 8.33189 2.58924C8.04013 2.95517 7.83927 3.33592 7.54768 4.36394L7.36727 5H5.56222H5C4.44772 5 4 5.44772 4 6C4 6.55228 4.44772 7 5 7H5.50029L6.34446 19.6662C6.43199 20.9795 7.52275 22 8.83893 22H15.1611C16.4773 22 17.568 20.9795 17.6556 19.6663L18.5 7.00072V7H19C19.5523 7 20 6.55228 20 6C20 5.44772 19.5523 5 19 5H18.5H16.6327L16.4523 4.36394C16.1607 3.33592 15.9599 2.95517 15.6681 2.58924C15.3764 2.22332 15.0161 1.95101 14.5844 1.77018C14.1528 1.58935 13.7317 1.5 12.6631 1.5ZM14.5538 5L14.5282 4.90969C14.325 4.19321 14.2389 4.0049 14.1043 3.83606C14.0219 3.73265 13.9336 3.66595 13.8116 3.61485C13.6125 3.53141 13.4078 3.5 12.6631 3.5H11.3369C10.5922 3.5 10.3875 3.53141 10.1884 3.61485C10.0664 3.66595 9.97812 3.73265 9.89568 3.83606C9.76106 4.0049 9.675 4.19321 9.47178 4.90969L9.44617 5H14.5538ZM16.4956 7H7.50473L8.34004 19.5332C8.35754 19.7959 8.57569 20 8.83893 20H15.1611C15.4244 20 15.6425 19.7959 15.66 19.5333L16.4956 7ZM9.39966 9.63056C9.38328 9.1614 9.75033 8.76779 10.2195 8.75141C10.6886 8.73503 11.0822 9.10207 11.0986 9.57123L11.3708 17.3665C11.3872 17.8356 11.0202 18.2292 10.551 18.2456C10.0819 18.262 9.68826 17.895 9.67188 17.4258L9.39966 9.63056ZM13.781 8.75141C13.3119 8.73503 12.9183 9.10207 12.9019 9.57123L12.6297 17.3665C12.6133 17.8356 12.9803 18.2292 13.4495 18.2456C13.9186 18.262 14.3122 17.895 14.3286 17.4258L14.6008 9.63056C14.6172 9.1614 14.2502 8.76779 13.781 8.75141Z'
                fill='#262633'
            />
        </svg>
    ),
    plus: (
        <svg width='24' height='24' viewBox='0 0 24 24' fill='none' xmlns='http://www.w3.org/2000/svg' className={b()}>
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M12 3C11.4477 3 11 3.44772 11 4V11H4C3.44772 11 3 11.4477 3 12C3 12.5523 3.44772 13 4 13H11V20C11 20.5523 11.4477 21 12 21C12.5523 21 13 20.5523 13 20V13H20C20.5523 13 21 12.5523 21 12C21 11.4477 20.5523 11 20 11H13V4C13 3.44772 12.5523 3 12 3Z'
                fill='#262633'
            />
        </svg>
    ),
    arrowBottom: (
        <svg width='24' height='24' viewBox='0 0 24 24' fill='none' xmlns='http://www.w3.org/2000/svg' className={b()}>
            <path
                d='M12 14.5858L18.2929 8.29289C18.6834 7.90237 19.3166 7.90237 19.7071 8.29289C20.0976 8.68342 20.0976 9.31658 19.7071 9.70711L13.0607 16.3536C12.4749 16.9393 11.5251 16.9393 10.9393 16.3536L4.29289 9.70711C3.90237 9.31658 3.90237 8.68342 4.29289 8.29289C4.68342 7.90237 5.31658 7.90237 5.70711 8.29289L12 14.5858Z'
                fill='#B3B8CC'
            />
        </svg>
    ),
    arrowRight: (
        <svg
            width='16'
            height='16'
            viewBox='0 0 16 16'
            fill='#85889E'
            xmlns='http://www.w3.org/2000/svg'
            className={b({smaller: true})}
        >
            <path d='M9.58627 8L4.7964 12.7931C4.40601 13.1838 4.40622 13.817 4.79688 14.2073C5.18754 14.5977 5.8207 14.5975 6.2111 14.2069L11.7073 8.70687C12.0976 8.3164 12.0976 7.6836 11.7073 7.29313L6.2111 1.79313C5.8207 1.40248 5.18754 1.40226 4.79688 1.79265C4.40622 2.18304 4.40601 2.81621 4.7964 3.20687L9.58627 8Z' />
        </svg>
    ),
    burger: (
        <svg
            width='16'
            height='16'
            viewBox='0 0 16 16'
            xmlns='http://www.w3.org/2000/svg'
            className={b({smaller: true})}
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M1.33398 4.66667C1.33398 4.29848 1.63246 4 2.00065 4H14.0007C14.3688 4 14.6673 4.29848 14.6673 4.66667C14.6673 5.03486 14.3688 5.33333 14.0007 5.33333H2.00065C1.63246 5.33333 1.33398 5.03486 1.33398 4.66667ZM1.33398 8C1.33398 7.63181 1.63246 7.33333 2.00065 7.33333H14.0007C14.3688 7.33333 14.6673 7.63181 14.6673 8C14.6673 8.36819 14.3688 8.66667 14.0007 8.66667H2.00065C1.63246 8.66667 1.33398 8.36819 1.33398 8ZM2.00065 10.6667C1.63246 10.6667 1.33398 10.9651 1.33398 11.3333C1.33398 11.7015 1.63246 12 2.00065 12H10.0007C10.3688 12 10.6673 11.7015 10.6673 11.3333C10.6673 10.9651 10.3688 10.6667 10.0007 10.6667H2.00065Z'
                fill='#262633'
            />
        </svg>
    ),
    question: (
        <svg
            width='13'
            height='12'
            viewBox='0 0 13 12'
            fill='none'
            xmlns='http://www.w3.org/2000/svg'
            className={b({small: true})}
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M0.5 6C0.5 9.31371 3.18629 12 6.5 12C9.81371 12 12.5 9.31371 12.5 6C12.5 2.68629 9.81371 0 6.5 0C3.18629 0 0.5 2.68629 0.5 6ZM11 6C11 8.48528 8.98528 10.5 6.5 10.5C4.01472 10.5 2 8.48528 2 6C2 3.51472 4.01472 1.5 6.5 1.5C8.98528 1.5 11 3.51472 11 6ZM4.3835 4.572C4.3835 3.33 5.4095 2.574 6.7055 2.574C7.9835 2.574 8.9375 3.33 8.9375 4.446V4.482C8.9375 5.544 8.2535 5.976 7.6145 6.255L7.4525 6.327C7.2365 6.426 7.1645 6.543 7.1645 6.804C7.1645 6.93323 7.05973 7.038 6.9305 7.038H6.3005C6.12156 7.038 5.9765 6.89294 5.9765 6.714C5.9765 6.102 6.1925 5.715 6.7595 5.463L6.9215 5.391C7.4615 5.148 7.7495 4.95 7.7495 4.5C7.7495 4.014 7.3355 3.69 6.7055 3.69C6.0575 3.69 5.5715 4.014 5.5715 4.626C5.5715 4.74529 5.47479 4.842 5.3555 4.842H4.6535C4.50438 4.842 4.3835 4.72112 4.3835 4.572ZM6.5705 7.416C6.0845 7.416 5.7155 7.767 5.7155 8.271C5.7155 8.775 6.0845 9.126 6.5705 9.126C7.0565 9.126 7.4255 8.775 7.4255 8.271C7.4255 7.767 7.0565 7.416 6.5705 7.416Z'
                fill='#85889E'
            />
        </svg>
    ),
    apps: (
        <svg
            width='24'
            height='24'
            viewBox='0 0 24 24'
            fill='#85889E'
            xmlns='http://www.w3.org/2000/svg'
            className={b()}
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M18 4.00003C18 3.44775 17.5523 3.00003 17 3.00003C16.4477 3.00003 16 3.44775 16 4.00003V6.00003H14C13.4477 6.00003 13 6.44775 13 7.00003C13 7.55232 13.4477 8.00003 14 8.00003H16V10C16 10.5523 16.4477 11 17 11C17.5523 11 18 10.5523 18 10V8.00003H20C20.5523 8.00003 21 7.55232 21 7.00003C21 6.44775 20.5523 6.00003 20 6.00003H18V4.00003ZM5.49718 3.00621L9.99887 3.00113C10.5523 3.00113 11 3.44884 11 4.00113V10C11 10.5523 10.5523 11 10 11H4C3.44772 11 3 10.5523 3 10V5.5062C3 4.12659 4.11757 3.00776 5.49718 3.00621ZM3.99887 13.0079C3.44703 13.0085 3 13.456 3 14.0079V18.5C3 19.8807 4.11929 21 5.5 21H10C10.5523 21 11 20.5523 11 20V14.0011C11 13.4488 10.5523 13.0011 9.99887 13.0011L3.99887 13.0079ZM13.9989 13.0079C13.447 13.0085 13 13.456 13 14.0079V20C13 20.5523 13.4477 21 14 21H18.5C19.8807 21 21 19.8807 21 18.5V14.0011C21 13.4488 20.5523 13.0011 19.9989 13.0011L13.9989 13.0079ZM5.5 19C5.22386 19 5 18.7761 5 18.5V15.0068L9 15.0023V19H5.5ZM15 19H18.5C18.7761 19 19 18.7761 19 18.5V15.0023L15 15.0068V19ZM9 5.00226V9H5V5.5062C5 5.23028 5.22351 5.00652 5.49944 5.0062L9 5.00226Z'
            />
        </svg>
    ),
    plusRounded: (
        <svg
            width='24'
            height='24'
            viewBox='0 0 24 24'
            fill='#85889E'
            xmlns='http://www.w3.org/2000/svg'
            className={b()}
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12ZM20 12C20 16.4183 16.4183 20 12 20C7.58172 20 4 16.4183 4 12C4 7.58172 7.58172 4 12 4C16.4183 4 20 7.58172 20 12ZM6.99979 12.9996C6.44751 12.9995 5.99989 12.5517 6 11.9994C6.00011 11.4471 6.44792 10.9995 7.00021 10.9996L11 11.0004V7C11 6.44772 11.4477 6 12 6C12.5523 6 13 6.44772 13 7V11.0008L17.0002 11.0016C17.5525 11.0017 18.0001 11.4496 18 12.0018C17.9999 12.5541 17.5521 13.0017 16.9998 13.0016L13 13.0008V17C13 17.5523 12.5523 18 12 18C11.4477 18 11 17.5523 11 17V13.0004L6.99979 12.9996Z'
            />
        </svg>
    ),
    help: (
        <svg
            width='24'
            height='24'
            viewBox='0 0 24 24'
            fill='#85889E'
            xmlns='http://www.w3.org/2000/svg'
            className={b()}
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12ZM20 12C20 16.4183 16.4183 20 12 20C7.58172 20 4 16.4183 4 12C4 7.58172 7.58172 4 12 4C16.4183 4 20 7.58172 20 12ZM11.4618 17.5036C10.4367 17.5036 10.1001 16.8763 10.1001 16.2949C10.1001 16.0501 10.1766 15.6829 10.2378 15.4687L11.3088 10.8568H10.0552C9.89415 10.8568 9.77512 10.7068 9.81172 10.55L9.88758 10.225C9.91944 10.0885 10.0296 9.98421 10.1676 9.95987L13.0055 9.45931C13.3602 9.39675 13.6627 9.71836 13.5786 10.0685L12.1411 16.0502C12.1198 16.1388 12.1648 16.23 12.2481 16.267C12.3259 16.3015 12.4172 16.2798 12.471 16.2139L13.6358 14.789C13.7395 14.662 13.9221 14.6334 14.0598 14.7224C14.2122 14.8211 14.2529 15.0261 14.1498 15.1755L13.4508 16.1878C12.7164 17.2588 12.0432 17.5036 11.4618 17.5036ZM11.8 7.6417C11.8 8.1466 12.1978 8.575 12.9016 8.575C13.5901 8.575 14.095 8.1925 14.248 7.5805C14.2786 7.4581 14.2939 7.3204 14.2939 7.2133C14.2939 6.7084 13.8961 6.28 13.1923 6.28C12.5191 6.28 11.9989 6.6625 11.8459 7.2745C11.8153 7.3969 11.8 7.5346 11.8 7.6417Z'
            />
        </svg>
    ),
    id: (
        <svg
            width='24'
            height='24'
            viewBox='0 0 24 24'
            fill='#85889E'
            xmlns='http://www.w3.org/2000/svg'
            className={b()}
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M13.1099 2.06095C12.5609 2.00027 12.0667 2.39608 12.0061 2.94502C11.9454 3.49396 12.3412 3.98816 12.8901 4.04884C15.7206 4.36174 18.1098 6.15393 19.262 8.63882C19.4944 9.13985 20.0889 9.35767 20.5899 9.12534C21.091 8.893 21.3088 8.29848 21.0765 7.79744C19.638 4.69538 16.655 2.45285 13.1099 2.06095ZM8.71328 4.70388C9.21668 4.47671 9.44061 3.88446 9.21344 3.38106C8.98627 2.87766 8.39403 2.65373 7.89062 2.8809C4.41929 4.44741 2 7.94009 2 12C2 17.5228 6.47715 22 12 22C17.148 22 21.3862 18.1108 21.939 13.1098C21.9997 12.5609 21.6039 12.0667 21.0549 12.006C20.506 11.9453 20.0118 12.3412 19.9511 12.8901C19.5091 16.889 16.1172 20 12 20C7.58172 20 4 16.4182 4 12C4 8.75483 5.93228 5.95886 8.71328 4.70388ZM8.79949 14.3998C8.46775 13.9582 7.84087 13.8692 7.39932 14.201C6.95777 14.5327 6.86876 15.1596 7.2005 15.6011C8.29348 17.0559 10.0366 18 12 18C13.9634 18 15.7065 17.0559 16.7995 15.6011C17.1312 15.1596 17.0422 14.5327 16.6007 14.201C16.1591 13.8692 15.5322 13.9582 15.2005 14.3998C14.469 15.3734 13.3078 16 12 16C10.6922 16 9.53097 15.3734 8.79949 14.3998Z'
            />
        </svg>
    ),
    greenCheck: (
        <svg
            width='33'
            height='32'
            viewBox='0 0 33 32'
            fill='none'
            xmlns='http://www.w3.org/2000/svg'
            className={b({big: true})}
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M16.5003 29.3332C23.8641 29.3332 29.8337 23.3636 29.8337 15.9998C29.8337 8.63604 23.8641 2.6665 16.5003 2.6665C9.13653 2.6665 3.16699 8.63604 3.16699 15.9998C3.16699 23.3636 9.13653 29.3332 16.5003 29.3332ZM16.5003 26.6665C22.3914 26.6665 27.167 21.8909 27.167 15.9998C27.167 10.1088 22.3914 5.33317 16.5003 5.33317C10.6093 5.33317 5.83366 10.1088 5.83366 15.9998C5.83366 21.8909 10.6093 26.6665 16.5003 26.6665ZM22.7145 11.0016C22.1605 10.5166 21.3181 10.5725 20.8331 11.1265L14.8112 18.0042L12.1502 15.0992C11.6528 14.5562 10.8094 14.5193 10.2664 15.0167C9.72338 15.5141 9.68641 16.3575 10.1838 16.9005L13.3477 20.3543C14.0938 21.1688 15.3589 21.2243 16.1734 20.4782C16.2133 20.4403 16.2332 20.4213 16.2524 20.4016C16.2717 20.382 16.2902 20.3616 16.3272 20.3209L22.8394 12.8831C23.3245 12.3291 23.2686 11.4867 22.7145 11.0016Z'
                fill='#00A85A'
            />
        </svg>
    ),
    copy: (
        <svg
            width='24'
            height='24'
            viewBox='0 0 24 24'
            fill='#85889E'
            xmlns='http://www.w3.org/2000/svg'
            className={b()}
        >
            <path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M8 5H10H15.7951C16.9095 5 17.3137 5.11603 17.7211 5.33392C18.1285 5.5518 18.4482 5.87154 18.6661 6.27894C18.884 6.68635 19 7.09046 19 8.20486V16C19 16.5523 19.4477 17 20 17C20.5523 17 21 16.5523 21 16V8.12777C21 6.34473 20.8143 5.69816 20.4657 5.04631C20.1171 4.39446 19.6055 3.88288 18.9537 3.53427C18.3018 3.18565 17.6553 3 15.8722 3H10H8C7.44772 3 7 3.44772 7 4C7 4.55228 7.44772 5 8 5ZM6.20486 7C5.32287 7 4.81249 7.04857 4.27894 7.33392C3.87153 7.5518 3.5518 7.87154 3.33392 8.27894C3.04857 8.81249 3 9.32287 3 10.2049V17.7951C3 18.6771 3.04857 19.1875 3.33392 19.7211C3.5518 20.1285 3.87153 20.4482 4.27894 20.6661C4.81249 20.9514 5.32287 21 6.20486 21H13.7951C14.6771 21 15.1875 20.9514 15.7211 20.6661C16.1285 20.4482 16.4482 20.1285 16.6661 19.7211C16.9514 19.1875 17 18.6771 17 17.7951V10.2049C17 9.32287 16.9514 8.81249 16.6661 8.27894C16.4482 7.87154 16.1285 7.5518 15.7211 7.33392C15.1875 7.04857 14.6771 7 13.7951 7H6.20486ZM5.22214 9.09754C5.27244 9.07064 5.3124 9.05274 5.41912 9.03611C5.55707 9.01462 5.78184 9 6.20486 9H13.7951C14.2182 9 14.4429 9.01462 14.5809 9.03611C14.6876 9.05274 14.7276 9.07064 14.7779 9.09754C14.8367 9.12903 14.871 9.16327 14.9025 9.22214C14.9294 9.27244 14.9473 9.3124 14.9639 9.41912C14.9854 9.55707 15 9.78184 15 10.2049V17.7951C15 18.2182 14.9854 18.4429 14.9639 18.5809C14.9473 18.6876 14.9294 18.7276 14.9025 18.7779C14.871 18.8367 14.8367 18.871 14.7779 18.9025C14.7276 18.9294 14.6876 18.9473 14.5809 18.9639C14.4429 18.9854 14.2182 19 13.7951 19H6.20486C5.78184 19 5.55707 18.9854 5.41912 18.9639C5.3124 18.9473 5.27244 18.9294 5.22214 18.9025C5.16327 18.871 5.12903 18.8367 5.09754 18.7779C5.07064 18.7276 5.05274 18.6876 5.03611 18.5809C5.01462 18.4429 5 18.2182 5 17.7951V10.2049C5 9.78184 5.01462 9.55707 5.03611 9.41912C5.05274 9.3124 5.07064 9.27244 5.09754 9.22214C5.12903 9.16327 5.16327 9.12903 5.22214 9.09754Z'
            />
        </svg>
    )
};

export const ClientIcon = ({type}) => ICONS[type] || null;
