import React from 'react';
import {cn} from '@bem-react/classname';
import {dateToText} from '../../../../../utils';

import './ClientItemCard.styl';

const b = cn('ClientItemCard');

export const ClientItemCard = ({iconUrl, title, description, onClick, createTime, clientId, view} = {}) => {
    if (view === 'create') {
        return (
            <div className={b()} onClick={onClick}>
                <div className={b('content')}>
                    <div className={b('icon', {create: true})} />
                    <div className={b('title', {create: true})}>{title}</div>
                </div>
            </div>
        );
    }

    return (
        <div className={b()} onClick={onClick} data-client-id={clientId}>
            <div className={b('content')}>
                {iconUrl && (
                    <div
                        className={b('icon')}
                        style={{backgroundImage: `url('${iconUrl.replace('/normal', '/big')}')`}}
                    />
                )}
                <div className={b('textContent')}>
                    <div className={b('top')}>
                        <div className={b('title', {marginBottom: Boolean(description)})}>{title}</div>
                        {description && <div className={b('description')}>{description}</div>}
                    </div>

                    <div className={b('clientId')}>ClientID: ••• {clientId.substr(-5)}</div>
                    {createTime && <div className={b('createTime')}>{dateToText(new Date(createTime * 1000))}</div>}
                </div>
            </div>
        </div>
    );
};
