import React from 'react';
import {Popup} from 'pcomponents/Popup';
import {cn} from '@bem-react/classname';
import {ClientIcon} from '../ClientIcon';

import './ClientModerationMark.styl';

const b = cn('ClientModerationMark');

export class ClientModerationMark extends React.Component {
    ref = React.createRef(null);
    state = {isOpened: false};
    onModerationClick = () => this.setOpenStatus(!this.state.isOpened);
    onPopupClose = () => this.setOpenStatus(false);
    setOpenStatus = (isOpened) => {
        const {onChange} = this.props;

        if (typeof onChange === 'function') {
            isOpened ? this.props.onChange(true) : setTimeout(() => this.props.onChange(false), 0);
        }

        this.setState({isOpened});
    };
    render() {
        return (
            <>
                <div className={b()} onClick={this.onModerationClick} ref={this.ref}>
                    <div className={b('text')}>{i18n('ClientCommon.moderationMark.text')}</div>
                    <div className={b('icon')}>
                        <ClientIcon type='question' />
                    </div>
                </div>
                <Popup
                    hasTail={true}
                    directions={['top-center', 'right-center', 'bottom-center', 'left-center', 'top-center']}
                    target='anchor'
                    view='black'
                    mainOffset={8}
                    anchor={this.ref}
                    visible={this.state.isOpened}
                    onClose={this.onPopupClose}
                    zIndex={500}
                >
                    <div className={b('popup')}>{i18n('ClientCommon.moderationMark.popup')}</div>
                </Popup>
            </>
        );
    }
}
