import React from 'react';
import {Link} from 'react-router-dom';
import {cn} from '@bem-react/classname';
import {ROUTES} from '../../../const';
import {metric} from '../../../metric';
import {ClientIcon} from '../ClientIcon';

import './ClientNavigation.styl';

const b = cn('ClientNavigation');

const navigationLinks = [
    {
        to: ROUTES.LIST,
        title: i18n('ClientCommon.nav.list'),
        icon: <ClientIcon type='apps' />,
        goal: 'lk_menu_my_app_click'
    },
    {
        to: ROUTES.FORM_CREATE,
        title: i18n('ClientCommon.nav.form'),
        icon: <ClientIcon type='plusRounded' />,
        goal: 'lk_menu_new_clientID_click'
    },
    {
        // eslint-disable-next-line max-len
        href: 'https://yandex.%tld/dev/id/doc/dg/?utm_source=yandex&utm_medium=yandex-id&utm_campaign=link-owners-sites',
        title: i18n('ClientCommon.nav.docs'),
        icon: <ClientIcon type='help' />,
        goal: 'lk_menu_doc_click'
    },
    {
        href: 'https://id.yandex.%tld/business?utm_source=yandex&utm_medium=yandex-id&utm_campaign=link-owners-sites',
        title: i18n('ClientCommon.nav.about'),
        icon: <ClientIcon type='id' />,
        goal: 'lk_menu_about_ID_click'
    }
];

const renderText = (icon, title) => (
    <>
        <div className={b('icon')}>{icon}</div>
        <div className={b('text')}>{title}</div>
    </>
);

export class ClientNavigation extends React.Component {
    onItemWrapClick = (e) => {
        const {index} = e.currentTarget.dataset;
        const {goal} = navigationLinks[Number(index)];

        metric.goal(goal);
    };
    isLinkActive = (to) => {
        const {location: {pathname = ''} = {}} = this.props;
        const isFormCreatePathname = pathname.startsWith(ROUTES.FORM_CREATE);

        return to.startsWith(ROUTES.FORM_CREATE) ? isFormCreatePathname : !isFormCreatePathname;
    };
    render() {
        const {tld = 'ru'} = this.props;

        return (
            <div className={b()}>
                {navigationLinks.map(({to, href, title, icon}, i) => (
                    <div key={href || to} className={b('itemWrap')} onClick={this.onItemWrapClick} data-index={i}>
                        {href ? (
                            <a href={href.replace('%tld', tld)} className={b('item')} target='_blank' rel='noreferrer'>
                                {renderText(icon, title)}
                            </a>
                        ) : (
                            <Link to={to} className={b('item', {active: this.isLinkActive(to)})}>
                                {renderText(icon, title)}
                            </Link>
                        )}
                    </div>
                ))}
            </div>
        );
    }
}
