import React from 'react';
import {cn} from '@bem-react/classname';
import {getDocumentationTld} from '../../../../../utils';
import {metric} from '../../../metric';

import './ClientNextStepsInfo.styl';

const b = cn('ClientNextStepsInfo');

export const ClientNextStepsInfo = ({tld, documentationLinks} = {}) => {
    const STEPS = [
        {
            title: i18n('ClientCommon.clientNextStep.step1.title'),
            links: [
                {
                    text: i18n('ClientCommon.clientNextStep.link.getCode'),
                    goal: 'lk_my_app_step1_confirm_code_click',
                    link: documentationLinks.getCode
                },
                {
                    text: i18n('ClientCommon.clientNextStep.link.tradeCode'),
                    goal: 'lk_my_app_step1_token_click',
                    link: documentationLinks.tradeCode
                },
                {
                    text: i18n('ClientCommon.clientNextStep.link.requestInfoByToken'),
                    goal: 'lk_my_app_step1_urerinf_click',
                    link: documentationLinks.requestInfoByToken
                }
            ]
        },
        {
            title: i18n('ClientCommon.clientNextStep.step2.title'),
            links: [
                {
                    text: i18n('ClientCommon.clientNextStep.link.step2'),
                    goal: 'lk_my_app_step2_suggest_click',
                    links: {
                        sdk: {
                            link: documentationLinks.mobileSDKs,
                            text: i18n('ClientCommon.clientNextStep.link.step2.sdk')
                        }
                    }
                }
            ]
        },
        {
            title: i18n('ClientCommon.clientNextStep.step3.title'),
            links: [
                {
                    text: i18n('ClientCommon.clientNextStep.link.step3'),
                    goal: 'lk_my_app_step3_figma_click',
                    links: {
                        buttons: {
                            link: documentationLinks.designGuidesButtons,
                            text: i18n('ClientCommon.clientNextStep.link.step3.buttons')
                        },
                        guides: {
                            link: documentationLinks.designGuides,
                            text: i18n('ClientCommon.clientNextStep.link.step3.guides')
                        }
                    }
                }
            ]
        }
    ];

    const documentationTld = getDocumentationTld(tld);

    return (
        <div className={b()}>
            <div className={b('title')}>{i18n('ClientCommon.clientNextStep.title')}</div>
            <div className={b('stepsList')}>
                {STEPS.map(({title, links}, i) => (
                    <div className={b('stepsItem')} key={title}>
                        <div className={b('stepIcon')}>{i + 1}</div>
                        <div className={b('stepContent')}>
                            <div className={b('stepTitle')}>{title}</div>
                            <div className={b('linksList')}>
                                {links.map(({text, link, links, goal}) =>
                                    link ? (
                                        <div className={b('linkWrap')} key={text} onClick={() => metric.goal(goal)}>
                                            <a
                                                className={b('link')}
                                                href={link.replace('%tld', documentationTld)}
                                                target='_blank'
                                                rel='noreferrer'
                                            >
                                                {text}
                                            </a>
                                        </div>
                                    ) : links ? (
                                        <span
                                            className={b('linkWrap')}
                                            key={text}
                                            onClick={() => metric.goal(goal)}
                                            dangerouslySetInnerHTML={{
                                                __html: Object.keys(links).reduce(
                                                    (acc, linkKey) =>
                                                        acc.replace(
                                                            `%${linkKey}`,
                                                            `<a href="${links[linkKey].link.replace(
                                                                '%tld',
                                                                documentationTld
                                                            )}" class="${b('link')}" target="_blank" rel="noreferrer">${
                                                                links[linkKey].text
                                                            }</a>`
                                                        ),
                                                    text
                                                )
                                            }}
                                        />
                                    ) : null
                                )}
                            </div>
                        </div>
                    </div>
                ))}
            </div>
        </div>
    );
};
