import React from 'react';
import {cn} from '@bem-react/classname';
import {ClientBurger} from '../ClientBurger';
import {ClientHeadUser} from '../ClientHeadUser';
import {ClientContent} from '../ClientContent';
import {ClientFooter} from '../ClientFooter';
import {ClientNavigation} from '../ClientNavigation';
import {IdLogo} from './IdLogo';

import './ClientPageTemplate.styl';

const b = cn('ClientPageTemplate');

export class ClientPageTemplate extends React.Component {
    render() {
        const {children} = this.props;

        return (
            <div className={b()}>
                <div className={b('header')}>
                    <div className={b('burger')}>
                        <ClientBurger>
                            <ClientNavigation />
                        </ClientBurger>
                    </div>
                    <div className={b('logo')}>
                        <IdLogo />
                    </div>
                    <div className={b('user')}>
                        <ClientHeadUser />
                    </div>
                </div>
                <div className={b('page')}>
                    <div className={b('aside')}>
                        <ClientNavigation />
                        <ClientFooter />
                    </div>
                    <div className={b('content')}>
                        <ClientContent> {children}</ClientContent>
                    </div>
                </div>
                <div className={b('footer')}>
                    <ClientFooter />
                </div>
            </div>
        );
    }
}
