import React from 'react';
import {Checkbox} from 'pcomponents/Checkbox';
import {cn} from '@bem-react/classname';
import {ClientModerationMark} from '../ClientModerationMark';

import './ClientPermissionCheckbox.styl';

const b = cn('ClientPermissionCheckbox');

export class ClientPermissionCheckbox extends React.Component {
    isModerationPopupOpened = false;

    onPermissionToggle = () => {
        const {editPermissionToggle, permission: {section = ''} = {}, permissionId} = this.props;

        if (!this.isModerationPopupOpened) {
            editPermissionToggle({section, permissionId});
        }
    };
    setModerationOpenedStatus = (status) => {
        this.isModerationPopupOpened = status;
    };
    render() {
        const {permission = {}, isChecked = false, permissionId = '', halfWidth = false, hideId = false} = this.props;

        return (
            <div className={b({halfWidth, hideId})}>
                <Checkbox
                    size='l'
                    className={b('checkbox')}
                    label={
                        <div className={b('label')}>
                            <div className={b('title')}>{permission.title}</div>
                            {permission.requiresApproval && (
                                <div className={b('moderation')}>
                                    <ClientModerationMark onChange={this.setModerationOpenedStatus} />
                                </div>
                            )}
                            <div className={b('id')}>{permissionId}</div>
                        </div>
                    }
                    checked={isChecked}
                    onChange={this.onPermissionToggle}
                />
            </div>
        );
    }
}
