import {connect} from 'react-redux';
import {editPermissionToggle} from '../../../middlewares/edit';
import {ClientPermissionCheckbox as Component} from './ClientPermissionCheckbox';

const mapStateToProps = ({edit: {scopes = {}} = {}, common: {permissionsById = {}} = {}} = {}, {permissionId = ''}) => {
    const permission = permissionsById[permissionId] || {};

    return {permission, isChecked: Boolean(scopes[permission.section] && scopes[permission.section][permissionId])};
};

const mapDispatchToProps = {editPermissionToggle};

export const ClientPermissionCheckbox = connect(mapStateToProps, mapDispatchToProps)(Component);
