import React from 'react';
import {cn} from '@bem-react/classname';
import {ClientIcon} from '../ClientIcon';
import {ClientPermissionCheckbox} from '../ClientPermissionCheckbox';

import './ClientScopeSection.styl';

const b = cn('ClientScopeSection');

export class ClientScopeSection extends React.Component {
    state = {isOpened: false};
    setPermissionsRef = (permissions) => {
        this.permissions = permissions;
    };
    onHeadClick = () => {
        if (!this.state.isOpened) {
            setTimeout(() => {
                this.permissions.style.height = '';
            }, 300);
            this.setState({isOpened: true});
        }
    };
    onArrowClick = () => {
        if (this.state.isOpened) {
            this.permissions.style.height = `${this.permissions.scrollHeight}px`;
            setTimeout(() => this.setState({isOpened: false}), 0);
        }
    };
    render() {
        const {section: {title = '', permissions = []} = {}, checkedPermissions = {}} = this.props;
        const {isOpened} = this.state;
        const counter = Object.keys(checkedPermissions).length;

        return (
            <div className={b({isOpened})}>
                <div className={b('head')} onClick={this.onHeadClick}>
                    <div className={b('title')}>{title}</div>
                    <div className={b('controls')}>
                        {Boolean(counter) && <div className={b('counter')}>{counter}</div>}
                        <div className={b('arrow')} onClick={this.onArrowClick}>
                            <ClientIcon type='arrowBottom' />
                        </div>
                    </div>
                </div>
                <div
                    className={b('permissions')}
                    ref={this.setPermissionsRef}
                    style={{height: isOpened ? this.permissions.scrollHeight : 0}}
                >
                    {permissions.map((permissionId) => (
                        <ClientPermissionCheckbox permissionId={permissionId} key={permissionId} />
                    ))}
                </div>
            </div>
        );
    }
}
