import React from 'react';
import {cn} from '@bem-react/classname';
import {metric} from '../../../metric';
import {ClientIcon} from '../ClientIcon';

import './ClientSideInfoLayout.styl';

const b = cn('ClientSideInfoLayout');

const onCopyClick = ({currentTarget: {dataset: {key} = {}} = {}} = {}) => {
    try {
        navigator.clipboard.writeText(key);
    } catch (e) {
        // что-то сделать;
    }
};

const textToCopyMap = ({prefix, text} = {}) =>
    text && (
        <li className={b('textItem')} data-key={text} onClick={onCopyClick} key={text}>
            <div className={b('text')}>
                {prefix && <div className={b('prefix')}>{prefix}</div>}
                <div className={b('url')}>{text}</div>
            </div>
            <div className={b('copy')}>
                <ClientIcon type='copy' />
            </div>
        </li>
    );

export class ClientSideInfoLayout extends React.Component {
    onTitleClick = () => metric.goal(this.props.goal);
    render() {
        const {title, href, description, textsToCopy = []} = this.props;

        return (
            <div className={b()}>
                <a className={b('title')} href={href} onClick={this.onTitleClick} target='_blank' rel='noreferrer'>
                    {title}
                    <div className={b('arrow')}>
                        <ClientIcon type='arrowRight' />
                    </div>
                </a>
                <div className={b('description')}>{description}</div>
                <ul className={b('textList')}>{textsToCopy.map(textToCopyMap)}</ul>
            </div>
        );
    }
}
