import React from 'react';
import {cn} from '@bem-react/classname';
import {getDocumentationTld} from '../../../../../utils';
import {metric} from '../../../metric';
import {ClientIcon} from '../ClientIcon';

import './UsefullInfoBlock.styl';

const b = cn('UsefullInfoBlock');

export const UsefullInfoBlock = ({tld, documentationLinks} = {}) => {
    const LINKS = [
        {
            text: i18n('ClientCommon.usefullInfo.instantLogin'),
            goal: 'lk_my_app_suggest_click',
            link: documentationLinks.instantLogin
        },
        {
            text: i18n('ClientCommon.usefullInfo.documentation'),
            goal: 'lk_my_app_doc_click',
            link: documentationLinks.documentation
        },
        {
            text: i18n('ClientCommon.usefullInfo.debuggingToken'),
            goal: 'lk_my_app_token_click',
            link: documentationLinks.debuggingToken
        },
        {
            text: i18n('ClientCommon.usefullInfo.mobileSDKs'),
            goal: 'lk_my_app_mob_SDK_click',
            link: documentationLinks.mobileSDKs
        },
        {
            text: i18n('ClientCommon.usefullInfo.designGuides'),
            goal: 'lk_my_app_figma_click',
            link: documentationLinks.designGuides
        }
    ];

    const documentationTld = getDocumentationTld(tld);

    return (
        <div className={b()}>
            <div className={b('title')}>{i18n('ClientCommon.usefullInfo.title')}</div>

            <div className={b('links')}>
                {LINKS.map(({link, text, goal}) => (
                    <a
                        className={b('link')}
                        key={link}
                        target='_blank'
                        rel='noreferrer'
                        href={link.replace('%tld', documentationTld)}
                        onClick={() => metric.goal(goal)}
                    >
                        <div className={b('text')}>{text}</div>
                        <div className={b('arrow')}>
                            <ClientIcon type='arrowRight' />
                        </div>
                    </a>
                ))}
            </div>
        </div>
    );
};
