import React from 'react';
import {Checkbox} from 'pcomponents/Checkbox';
import {ClientField} from '../../common/ClientField';

export class ClientCheckboxField extends React.Component {
    onChange = () => {
        const {field, value, editFieldChange} = this.props;

        editFieldChange({field, value: !value});
    };
    render() {
        const {label, value} = this.props;

        return (
            <ClientField>
                <Checkbox size='l' label={label} checked={value} onChange={this.onChange} />
            </ClientField>
        );
    }
}
