import React from 'react';
import {Attach} from 'pcomponents/Attach';
import {Button} from 'pcomponents/Button';
import {cn} from '@bem-react/classname';
import {ClientField} from '../../common/ClientField';
import {ClientIcon} from '../../common/ClientIcon';
import {FILE_FIELD_VIEW_TYPES, FORM_ERROR_FIELDS, FORM_FIELDS} from '../../../const';

import './ClientFileField.styl';

const b = cn('ClientFileField');

export class ClientFileField extends React.Component {
    state = {showError: false};
    onChange = (e) => {
        const file = e.target.files[0];
        const fileSizeInMb = file.size / 1024 / 1024;

        e.target.value = '';
        if (fileSizeInMb > 1) {
            this.setState({showError: true});
        } else {
            this.changeClientFile(file);
        }
    };
    onClear = () => this.changeClientFile(null);
    changeClientFile = (file) => {
        this.setState({showError: false});
        this.props.editFileFieldChange(file);
    };
    render() {
        const {title, description, descriptionError, isRequired, isSecondary, value, viewType} = this.props;
        const {showError} = this.state;

        return (
            <ClientField
                title={title}
                description={showError ? descriptionError : description}
                isRequired={isRequired}
                isSecondary={isSecondary}
                isDescriptionAsError={showError}
                errorField={FORM_ERROR_FIELDS[FORM_FIELDS.ICON]}
            >
                <div className={b()}>
                    {value && viewType === FILE_FIELD_VIEW_TYPES.PICTURE && (
                        <div className={b('icon')} style={{backgroundImage: `url('${value}')`}} />
                    )}
                    <Attach view='default' size='l' value={value} onChange={this.onChange} className={b('attach')}>
                        <ClientIcon type='attach' />
                        {value ? i18n('ClientCommon.fileField.change') : i18n('ClientCommon.fileField.set')}
                    </Attach>
                    {value && (
                        <Button view='default' size='l' onClick={this.onClear} className={b('clear')}>
                            <ClientIcon type='trash' />
                        </Button>
                    )}
                    {value && viewType === FILE_FIELD_VIEW_TYPES.NAME && <div className={b('name')}>{value.name}</div>}
                </div>
            </ClientField>
        );
    }
}
