import {connect} from 'react-redux';
import {FILE_FIELD_VIEW_TYPES, FORM_FIELDS} from '../../../const';
import {editFileFieldChange} from '../../../middlewares/edit';
import {ClientFileField as Component} from './ClientFileField';

const mapStateToProps = ({edit = {}} = {}) => {
    const viewTypePic = Boolean(edit[FORM_FIELDS.ICON_ID]);

    return {
        viewType: viewTypePic ? FILE_FIELD_VIEW_TYPES.PICTURE : FILE_FIELD_VIEW_TYPES.NAME,
        value: edit[viewTypePic ? FORM_FIELDS.ICON_URL : FORM_FIELDS.ICON] || null
    };
};
const mapDispatchToProps = {editFileFieldChange};

export const ClientFileField = connect(mapStateToProps, mapDispatchToProps)(Component);
