import React from 'react';
import {cn} from '@bem-react/classname';
import {Checkbox} from 'pcomponents/Checkbox';
import {ClientField} from '../../common/ClientField';
import {FORM_ERROR_FIELDS, FORM_FIELDS} from '../../../const';

import './ClientPlatformField.styl';

const b = cn('ClientPlatformField');

export class ClientPlatformField extends React.Component {
    onChange = ({target: {name, checked} = {}}) => {
        const {editFieldChange} = this.props;

        editFieldChange({field: FORM_FIELDS.PLATFORMS, value: {...this.props.value, [name]: checked}});
    };
    render() {
        const {title, description, isRequired, isSecondary, value, platformsFields} = this.props;

        return (
            <ClientField
                title={title}
                description={description}
                isRequired={isRequired}
                isSecondary={isSecondary}
                errorField={FORM_ERROR_FIELDS[FORM_FIELDS.PLATFORMS]}
            >
                <div className={b()}>
                    {platformsFields.map(({type, label, content}) => (
                        <div className={b('item')} key={type}>
                            <Checkbox
                                size='l'
                                label={label}
                                name={type}
                                checked={Boolean(value[type])}
                                onChange={this.onChange}
                            />
                            {value[type] && <div className={b('content')}>{content}</div>}
                        </div>
                    ))}
                </div>
            </ClientField>
        );
    }
}
