import React from 'react';
import {FORM_ERROR_FIELDS, FORM_FIELDS} from '../../../const';
import {ClientField} from '../../common/ClientField';
import {ClientPermissionCheckbox} from '../../common/ClientPermissionCheckbox';
import {ClientScopeSection} from '../../common/ClientScopeSection';

export class ClientScopesField extends React.Component {
    constructor(props) {
        super(props);

        const {match: {params: {tag = ''} = {}} = {}, permissionsById = {}} = props;

        this.state = {
            permissions: tag
                ? Object.keys(permissionsById).filter((permissionId) => {
                      const permission = permissionsById[permissionId];

                      return Boolean(permission.tags && permission.tags.length && permission.tags.includes(tag));
                  })
                : []
        };
    }
    render() {
        const {title, description, isRequired, isSecondary, sections = []} = this.props;
        const {permissions} = this.state;

        return (
            <ClientField
                title={title}
                description={description}
                isRequired={isRequired}
                isSecondary={isSecondary}
                errorField={FORM_ERROR_FIELDS[FORM_FIELDS.SCOPES]}
            >
                {permissions.length
                    ? permissions.map((i) => (
                          <ClientPermissionCheckbox key={i} permissionId={i} halfWidth={true} hideId={true} />
                      ))
                    : sections.map((section, i) => <ClientScopeSection section={section} key={i} />)}
            </ClientField>
        );
    }
}
