import React from 'react';
import {Input} from 'pcomponents/Input';
import {Button} from 'pcomponents/Button';
import {cn} from '@bem-react/classname';
import {ClientField} from '../../common/ClientField';
import {ClientIcon} from '../../common/ClientIcon';
import {ClientDevUrl} from '../../common/ClientDevUrl';

import './ClientTextArrayField.styl';
import {FORM_ERRORS, FORM_ERROR_FIELDS} from '../../../const';

const b = cn('ClientTextArrayField');

export class ClientTextArrayField extends React.Component {
    state = {errors: {}};
    componentDidUpdate(props) {
        if (this.props.validateError !== props.validateError) {
            this.updateErrors();
        }
    }
    updateErrors = () => {
        const {validateError} = this.props;

        if (!validateError || !Object.keys(validateError).length) {
            return this.setState({errors: {}});
        } else if (typeof validateError === 'string') {
            return this.setState({errors: {0: validateError}});
        } else {
            this.setState({errors: validateError});
        }
    };
    onInputChange = ({target: {dataset: {index} = {}, value} = {}} = {}) => this.onChange(value, Number(index));
    onChange = (value, index) =>
        this.onFieldChange(this.props.value.map((oldValue, i) => (i === Number(index) ? value : oldValue)));
    onPlusClick = () => this.onFieldChange([...this.props.value, '']);
    onTrashClick = (e) => this.onFieldChange(this.props.value.filter((_, i) => i !== Number(e.target.dataset.index)));
    onFieldChange = (value) => this.props.editFieldChange({field: this.props.field, value});
    render() {
        const {
            title,
            description,
            isRequired,
            isSecondary,
            isDisabled,
            value,
            field,
            placeholder,
            showDevUrl,
            showErrors
        } = this.props;

        const formErrors = FORM_ERRORS[FORM_ERROR_FIELDS[field]];

        return (
            <ClientField title={title} description={description} isRequired={isRequired} isSecondary={isSecondary}>
                <div className={b()}>
                    {value.map((curValue, i) => {
                        const showPlus = !isDisabled && i === value.length - 1;
                        const showTrash = !isDisabled && value.length !== 1;
                        const errorKey = showErrors && this.state.errors && this.state.errors[i];
                        const hint = errorKey && formErrors ? formErrors[errorKey] : null;

                        return (
                            <div className={b('item')} key={i}>
                                {hint && <div className='error-anchor' />}
                                <Input
                                    className={b('input', {showPlus, showTrash})}
                                    view='default'
                                    size='l'
                                    data-index={i}
                                    value={curValue}
                                    onChange={this.onInputChange}
                                    disabled={isDisabled}
                                    placeholder={placeholder}
                                    state={hint ? 'error' : undefined}
                                />
                                {showPlus && (
                                    <Button view='default' size='l' className={b('button')} onClick={this.onPlusClick}>
                                        <ClientIcon type='plus' />
                                    </Button>
                                )}
                                {showTrash && (
                                    <Button
                                        view='default'
                                        size='l'
                                        className={b('button')}
                                        onClick={this.onTrashClick}
                                        data-index={i}
                                    >
                                        <ClientIcon type='trash' />
                                    </Button>
                                )}
                                {hint && <div className={b('error')}>{hint}</div>}
                                {showDevUrl && (
                                    <div className={b('dev')}>
                                        <ClientDevUrl payload={i} onClick={this.onChange} />
                                    </div>
                                )}
                            </div>
                        );
                    })}
                </div>
            </ClientField>
        );
    }
}
