import {connect} from 'react-redux';
import {FORM_ERROR_FIELDS} from '../../../const';
import {editFieldChange} from '../../../middlewares/edit';
import {ClientTextArrayField as Component} from './ClientTextArrayField';

const emptyField = [''];

const mapStateToProps = ({edit = {}} = {}, {field = ''} = {}) => {
    const {showErrors = false, validateErrors = {}} = edit;
    const value = edit[field] && edit[field].length ? edit[field] : emptyField;
    const errorField = FORM_ERROR_FIELDS[field];
    const validateError = validateErrors[errorField];

    return {value, showErrors, validateError};
};
const mapDispatchToProps = {editFieldChange};

export const ClientTextArrayField = connect(mapStateToProps, mapDispatchToProps)(Component);
