import React from 'react';
import {Input} from 'pcomponents/Input';
import {TextArea} from 'pcomponents/TextArea';
import {cn} from '@bem-react/classname';
import {ClientField} from '../../common/ClientField';
import {ClientDevUrl} from '../../common/ClientDevUrl';

import './ClientTextField.styl';

const b = cn('ClientTextField');

export class ClientTextField extends React.Component {
    onInputChange = ({target: {value = ''} = {}} = {}) => this.onChange(value);
    onChange = (value) => {
        const {field, editFieldChange} = this.props;

        editFieldChange({field, value});
    };
    render() {
        const {
            title,
            description,
            placeholder,
            value,
            hint,
            isRequired = false,
            isSecondary = false,
            isTextarea = false,
            isDisabled = false,
            showDevUrl = false
        } = this.props;
        const Component = isTextarea ? TextArea : Input;
        const props = {view: 'default', size: 'l', value, onChange: this.onInputChange, placeholder};

        if (hint) {
            props.hint = hint;
            props.state = 'error';
        }
        if (!isTextarea) {
            props.hasClear = true;
        }
        if (isDisabled) {
            props.disabled = true;
        }

        return (
            <ClientField title={title} description={description} isRequired={isRequired} isSecondary={isSecondary}>
                {hint && <div className='error-anchor' />}
                <div className={b()}>
                    <Component {...props} />
                    {showDevUrl && (
                        <div className={b('dev')}>
                            <ClientDevUrl onClick={this.onChange} />
                        </div>
                    )}
                </div>
            </ClientField>
        );
    }
}
