import {connect} from 'react-redux';
import {FORM_ERRORS, FORM_ERROR_FIELDS} from '../../../const';
import {editFieldChange} from '../../../middlewares/edit';
import {ClientTextField as Component} from './ClientTextField';

const mapStateToProps = ({edit = {}} = {}, {field = ''} = {}) => {
    const {[field]: value = '', validateErrors = {}, showErrors = false} = edit;
    const formErrors = FORM_ERRORS[FORM_ERROR_FIELDS[field]];
    const validateError = validateErrors[FORM_ERROR_FIELDS[field]];

    return {
        value,
        hint: showErrors && validateError && formErrors ? formErrors[validateError] : ''
    };
};
const mapDispatchToProps = {editFieldChange};

export const ClientTextField = connect(mapStateToProps, mapDispatchToProps)(Component);
