import React from 'react';
import {ClientFormBlock} from '../../common/ClientFormBlock';
import {ClientTextField} from '../../fields/ClientTextField';
import {ClientFileField} from '../../fields/ClientFileField';
import {ClientPlatformField} from '../../fields/ClientPlatformField';
import {ClientTextArrayField} from '../../fields/ClientTextArrayField';
import {ClientScopesField} from '../../fields/ClientScopesField';
import {FORM_FIELDS, FORM_PLATFORMS} from '../../../const';
import {ClientCheckboxField} from '../../fields/ClientCheckboxField';

const fingerprintPlaceholder =
    '00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00';

export class ClientFormData extends React.Component {
    constructor(props) {
        super(props);

        this.platformsFields = [
            {
                label: i18n('ClientForm.data.platforms.web.title'),
                type: FORM_PLATFORMS.WEB,
                content: (
                    <ClientTextArrayField
                        title={i18n('ClientForm.data.platforms.web.callbackUrls.title')}
                        description={i18n('ClientForm.data.platforms.web.callbackUrls.description')}
                        isSecondary={true}
                        showDevUrl={true}
                        field={FORM_FIELDS.WEB_CALLBACK_URLS}
                        placeholder={props.devUrl}
                    />
                )
            },
            {
                label: i18n('ClientForm.data.platforms.ios.title'),
                type: FORM_PLATFORMS.IOS,
                content: (
                    <>
                        <ClientTextArrayField
                            title={i18n('ClientForm.data.platforms.ios.appId.title')}
                            description={i18n('ClientForm.data.platforms.ios.appId.description')}
                            isSecondary={true}
                            field={FORM_FIELDS.IOS_APP_ID}
                            placeholder='A1B2C3D4E5.com.myCompany.myApp1'
                        />
                        <ClientTextField
                            title={i18n('ClientForm.data.platforms.ios.appstoreUrl.title')}
                            description={i18n('ClientForm.data.platforms.ios.appstoreUrl.description')}
                            isSecondary={true}
                            field={FORM_FIELDS.IOS_APPSTORE_URL}
                            placeholder='http://apps.apple.com/<counrty>/app/<name>/id'
                        />
                        {props.hasIos && (
                            <ClientTextArrayField
                                title='Universal Link Domains'
                                isSecondary={true}
                                isDisabled={true}
                                field={FORM_FIELDS.IOS_DOMAINS}
                            />
                        )}
                    </>
                )
            },
            {
                label: i18n('ClientForm.data.platforms.android.title'),
                type: FORM_PLATFORMS.ANDROID,
                content: (
                    <>
                        <ClientTextArrayField
                            title={i18n('ClientForm.data.platforms.android.packageNames.title')}
                            isSecondary={true}
                            field={FORM_FIELDS.ANDROID_PACKAGE_NAMES}
                            placeholder='com.example.helloandroid'
                        />
                        <ClientTextField
                            title={i18n('ClientForm.data.platforms.android.appstoreUrl.title')}
                            description={i18n('ClientForm.data.platforms.android.appstoreUrl.description')}
                            isSecondary={true}
                            field={FORM_FIELDS.ANDROID_APPSTORE_URL}
                            placeholder='https://play.google.com/store/apps/details?id=<name>'
                        />
                        <ClientTextArrayField
                            title={i18n('ClientForm.data.platforms.android.fingerprints.title')}
                            isSecondary={true}
                            field={FORM_FIELDS.ANDROID_FINGERPRINTS}
                            placeholder={fingerprintPlaceholder}
                        />
                        {props.hasAndroid && (
                            <ClientTextArrayField
                                title='Custom URL Schemes'
                                isSecondary={true}
                                isDisabled={true}
                                field={FORM_FIELDS.ANDROID_SCHEMES}
                            />
                        )}
                    </>
                )
            },
            {
                label: i18n('ClientForm.data.platforms.turboapp.title'),
                type: FORM_PLATFORMS.TURBOAPP,
                content: (
                    <ClientTextField
                        title={i18n('ClientForm.data.platforms.turboapp.url.title')}
                        description={i18n('ClientForm.data.platforms.turboapp.url.description')}
                        isSecondary={true}
                        field={FORM_FIELDS.TURBOAPP_URL}
                        placeholder={i18n('ClientForm.data.platforms.turboapp.url.placeholder')}
                    />
                )
            }
        ];
    }
    render() {
        const {isCorporate} = this.props;

        return (
            <ClientFormBlock title={i18n('ClientForm.data.title')}>
                <ClientTextField
                    title={i18n('ClientForm.data.title.title')}
                    isRequired={true}
                    field={FORM_FIELDS.TITLE}
                    placeholder={i18n('ClientForm.data.title.placeholder')}
                />
                {isCorporate && (
                    <ClientCheckboxField label={i18n('ClientForm.data.isYandex.label')} field={FORM_FIELDS.IS_YANDEX} />
                )}
                <ClientFileField
                    title={i18n('ClientForm.data.icon.title')}
                    description={i18n('ClientForm.data.icon.description')}
                    descriptionError={i18n('ClientForm.data.icon.error')}
                    field={FORM_FIELDS.ICON}
                />
                <ClientPlatformField
                    title={i18n('ClientForm.data.platforms.title')}
                    isRequired={true}
                    field={FORM_FIELDS.PLATFORMS}
                    platformsFields={this.platformsFields}
                />
                <ClientScopesField title={i18n('ClientForm.data.scopes.title')} isRequired={true} />
            </ClientFormBlock>
        );
    }
}
