import {connect} from 'react-redux';
import {ClientFormData as Component} from './ClientFormData';

const mapStateToProps = ({
    edit: {clientId = ''} = {},
    clients: {clientsMap = {}} = {},
    common: {isCorporate = false} = {},
    settings: {devUrl = ''} = {}
} = {}) => {
    const {platforms: {ios: hasIos, android: hasAndroid} = {}} = clientId ? clientsMap[clientId] : {};

    return {devUrl, isCorporate, hasIos, hasAndroid};
};

export const ClientFormData = connect(mapStateToProps)(Component);
