import React from 'react';
import {ClientFormBlock} from '../../common/ClientFormBlock';
import {ClientTextField} from '../../fields/ClientTextField';
import {FORM_FIELDS} from '../../../const';

export const ClientFormExtra = () => (
    <ClientFormBlock title={i18n('ClientForm.extra.title')} subtitle={i18n('ClientForm.extra.subtitle')}>
        <ClientTextField
            title={i18n('ClientForm.extra.description.title')}
            description={i18n('ClientForm.extra.description.description')}
            field={FORM_FIELDS.DESCRIPTION}
            isTextarea={true}
        />
        <ClientTextField
            title={i18n('ClientForm.extra.homepage.title')}
            placeholder={i18n('ClientForm.extra.homepage.placeholder')}
            field={FORM_FIELDS.HOMEPAGE}
            showDevUrl={true}
        />
    </ClientFormBlock>
);
