import React from 'react';
import {Button} from 'pcomponents/Button';
import {cn} from '@bem-react/classname';
import {LINKS, ROUTES} from '../../../const';
import {metric} from '../../../metric';
import {ClientFormBlock} from '../../common/ClientFormBlock';
import {ClientIcon} from '../../common/ClientIcon';
import {formatTokenLifeSpan} from './utils';
import './ClientFormParams.styl';

const b = cn('ClientFormParams');

const getTokenText = (ttl, isRefreshable) => {
    if (ttl === undefined) {
        return i18n('frontend.app.app.ttl.not_defined');
    }
    let text = formatTokenLifeSpan(ttl);

    return ttl && isRefreshable ? `${i18n('frontend.app.app.ttl.at_least')} ${text}` : text;
};

export class ClientFormParams extends React.Component {
    state = {tokenText: ''};
    constructor(props) {
        super(props);

        this.state = {tokenText: getTokenText(props.ttl, props.ttlRefreshable)};
    }
    componentDidUpdate(props) {
        const {ttl, ttlRefreshable} = this.props;

        (ttl !== props.ttl || ttlRefreshable !== props.ttlRefreshable) && this.updateTokenText(ttl, ttlRefreshable);
    }
    updateTokenText = (ttl, ttlRefreshable) => this.setState({tokenText: getTokenText(ttl, ttlRefreshable)});
    onCancelClick = () => this.props.pushHistory(ROUTES.INFO.replace(':clientId', this.props.clientId));
    onCreateClick = () => {
        metric.goal('lk_new_clientID_click');
        this.props.postClientCreate();
    };
    onEditClick = () => this.props.postClientEdit();

    render() {
        const {clientId, requiresApproval, tld} = this.props;
        const {tokenText} = this.state;

        return (
            <ClientFormBlock title={i18n('ClientForm.params.title')}>
                <div className={b()}>
                    <div className={b('info')}>
                        <div className={b('infoItem')}>
                            <div className={b('infoKey')}>{i18n('ClientForm.params.info.moderated')}</div>
                            <div className={b('infoValue')}>
                                {requiresApproval
                                    ? i18n('frontend.app.app.approval.required')
                                    : i18n('frontend.app.app.approval.not_required')}
                            </div>
                        </div>
                        <div className={b('infoItem')}>
                            <div className={b('infoKey')}>{i18n('ClientForm.params.info.ttl')}</div>
                            <div className={b('infoValue')}>{tokenText}</div>
                        </div>
                    </div>
                    {Boolean(clientId) && (
                        <div className={b('invalidate')}>
                            <ClientIcon type='greenCheck' />
                            <div className={b('invalidateText')}>{i18n('ClientForm.params.invalidate.valid')}</div>
                        </div>
                    )}
                    <div className={b('buttons')}>
                        {clientId ? (
                            <>
                                <Button view='action' size='l' className={b('button')} onClick={this.onEditClick}>
                                    {i18n('ClientForm.params.button.edit')}
                                </Button>
                                <Button view='default' size='l' className={b('button')} onClick={this.onCancelClick}>
                                    {i18n('ClientForm.params.button.cancel')}
                                </Button>
                            </>
                        ) : (
                            <Button view='action' size='l' className={b('button')} onClick={this.onCreateClick}>
                                {i18n('ClientForm.params.button.create')}
                            </Button>
                        )}
                    </div>
                    <div
                        className={b('agreement')}
                        dangerouslySetInnerHTML={{
                            __html: i18n('ClientForm.params.agreement').replace(
                                '%link',
                                `<a href="${LINKS.FORM_CREATE_AGREEMENT.replace(
                                    '%tld',
                                    tld
                                )}" target="_blank" rel="noreferrer" class="${b('link')}">${i18n(
                                    'ClientForm.params.agreement.link'
                                )}</a>`
                            )
                        }}
                    />
                </div>
            </ClientFormBlock>
        );
    }
}
